* Title: 	figure11.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of trends in joblessness by region


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure11, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip RegionI PrimeMaleD UnempB wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for regions
*******************************************************************************

rename UnempB PMJobless
rename PrimeMaleD Total
foreach var in PMJobless Total {
	gen `var'_Coastal	= `var' if (RegionI == 0)
	gen `var'_EH		= `var' if (RegionI == 1)
	gen `var'_WH 		= `var' if (RegionI == 2)
}
drop PMJobless Total

collapse (sum) Total* PMJobless* [pw=wtsupp], by(year)
	
tsset year
foreach region in Coastal EH WH {
	gen JoblessRate_`region' =  100 * (L.PMJobless_`region' + PMJobless_`region' + F.PMJobless_`region') ///
									/ (L.Total_`region' + Total_`region' + F.Total_`region')
}

keep year JoblessRate* 
keep if (year >= 1978 & year <= 2015)

* Save dataset
compress
save output/figures/dta/figure11.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	JoblessRate_Coastal JoblessRate_EH JoblessRate_WH year, ///
		legend(label(1 "Coastal States") label(2 "Eastern Heartland") label(3 "Western Heartland")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year")  ytitle("Not Working Rate, percent")

graph save output/figures/gph/figure11, replace
graph export output/figures/eps/figure11.eps, as(eps) replace
export excel using output/figures/xlsx/figure11.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
